// $Id: CScrollBarImages.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CScrollBarImages.hpp"
#include "../Graphics/CTGAImage.hpp"
using Exponent::GUI::Graphics::CTGAImage;
using Exponent::GUI::Controls::CScrollBarImages;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CScrollBarImages, CCountedObject);

//	===========================================================================
CScrollBarImages::CScrollBarImages()
				: m_isValid(false)
				, m_topCap(NULL)
				, m_bottomCap(NULL)
				, m_thumb(NULL)
				, m_repeat(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CScrollBarImages);
}

//	===========================================================================
CScrollBarImages::~CScrollBarImages()
{
	EXPONENT_CLASS_DESTRUCTION(CScrollBarImages);
	FORGET_COUNTED_OBJECT(m_topCap);
	FORGET_COUNTED_OBJECT(m_bottomCap);
	FORGET_COUNTED_OBJECT(m_thumb);
	FORGET_COUNTED_OBJECT(m_repeat);
}

//	===========================================================================
CScrollBarImages &CScrollBarImages::operator = (const CScrollBarImages &other)
{
	if (this != &other)
	{
		this->setImages(other.m_topCap, other.m_bottomCap, other.m_thumb, other.m_repeat);
	}
	return *this;
}

//	===========================================================================
bool CScrollBarImages::isValid()
{
	return m_isValid;
}

//	===========================================================================
bool CScrollBarImages::drawScrollBarImages(CGraphics &graphics, const CRect &area, const bool isVertical)
{
	// Check that we are valid to draw properly
	if (!m_isValid)
	{
		return false;
	}

	// Check if the scrollable area is vertical or horizontal
	if (isVertical)
	{

	}
	else
	{
		// First we draw the top cap, on the left hand side
		const CRect topCapPosition(area.getLeft(), area.getTop(), m_topCap->getImageSize().getWidth(), m_topCap->getImageSize().getHeight());

		// Then we draw the end cap
		const CRect bottomCapPosition(area.getRight() - m_bottomCap->getImageSize().getWidth(), area.getTop(), m_bottomCap->getImageSize().getWidth(), m_bottomCap->getImageSize().getHeight());

		// Compute the position of the thumb
		const CRect thumbPosition(area.getCentralXPosition() - (m_thumb->getImageSize().getWidth() / 2), area.getTop(), m_thumb->getImageSize().getWidth(), m_thumb->getImageSize().getHeight());

		// COmpute the repeat area
		const CRect repeatPosition(area.getLeft() + m_topCap->getImageSize().getWidth(), area.getTop(), (area.getRight() - m_bottomCap->getImageSize().getWidth()) - (area.getLeft() + m_topCap->getImageSize().getWidth()), m_repeat->getImageSize().getHeight());

		// Draw the repeat
		graphics.drawImage(m_repeat, repeatPosition, m_repeat->getNormalisedImageSize());

		// Draw the top cap
		graphics.drawImage(m_topCap, topCapPosition, m_topCap->getNormalisedImageSize());

		// Draw the bottom cap
		graphics.drawImage(m_bottomCap, bottomCapPosition, m_bottomCap->getNormalisedImageSize());

		// Draw the thumb in position
		graphics.drawImage(m_thumb, thumbPosition, m_thumb->getNormalisedImageSize());
	}

	// We drew properly
	return true;
}

//	===========================================================================
void CScrollBarImages::setImages(IImage *topCap, IImage *bottomCap, IImage *thumb, IImage *repeat)
{
	EXCHANGE_COUNTED_OBJECTS(m_topCap,    topCap);
	EXCHANGE_COUNTED_OBJECTS(m_bottomCap, bottomCap);
	EXCHANGE_COUNTED_OBJECTS(m_thumb,	  thumb);
	EXCHANGE_COUNTED_OBJECTS(m_repeat,	  repeat);
	m_isValid = (m_topCap != NULL && m_bottomCap != NULL && m_thumb != NULL	&& m_repeat != NULL);
}

//	===========================================================================
void CScrollBarImages::loadFromResourceFolder(const CSystemString &resourceFolder)
{
	this->setImages(CTGAImage::getNewInstance(resourceFolder, "ScrollBarTopCap.tga"),
					CTGAImage::getNewInstance(resourceFolder, "ScrollBarEndCap.tga"),
					CTGAImage::getNewInstance(resourceFolder, "ScrollBarThumb.tga"),
					CTGAImage::getNewInstance(resourceFolder, "ScrollBarRepeat.tga"));
}